import os, time, threading
import main

def filehandler(S, currAlgorithm, filepath, outputFile, writeMode="w"):
    startTime = time.time()

    with open(f"{filepath}.fna", "r") as file:
        T = "".join(file.read().splitlines())

    print(f"searching for {S} in {len(T)} chars with {currAlgorithm}")   
    
    outputData = eval(f"main.{currAlgorithm}(S, T)")

    runningTime = time.time() - startTime

    outputString = '; '.join(outputData)

    with open(outputFile, writeMode) as file:
        file.write(f"S: {S}; algorithm: {currAlgorithm}; time: {runningTime}s\n{outputString}\n")
        
    print(f"finished in {runningTime}s")    #; Matches:\n{outputString}


if __name__=='__main__': 
    #S = "CAGGACCGGGATTCCCCAAGGGGGCTGCTCCCAGAGGGTGTGTTGCTGGGATTGCCCAGGACAGGGATGGCCCTCTCATCAGGTGGGGGTGAGTGGCAGC"
    S_arr = "TAACCCTAAACCCTAAACCCTAACCCTAACCCTAACCCTAACCCTAACCCCAACCCCAACCCCAACCCCAACCCCAACCCCAACCCTAACCCCTAACCCT"
    S = "TAACCCTAAACCCTA"    
    currAlgorithm = "algorithm3"
    baseFolder = os.getcwd()
    filepath = f"{baseFolder}\exampleData\chromsome1"
    
    filehandler(S, currAlgorithm, filepath, f"{filepath}_{currAlgorithm}.fna")
    
    """ for i in range(1, 11):
        filehandler(S_arr[:i*10+1], currAlgorithm, filepath, f"{filepath}_statistics.fna", "a") """